% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAOI.R
\name{getZone}
\alias{getZone}
\title{Find LANDFIRE map zone for use with \code{landfireAPI()}}
\usage{
getZone(data)
}
\arguments{
\item{data}{An sf object or character string with the map zone name.}
}
\value{
Returns a numeric vector containing the map zone(s)
}
\description{
\code{getZone} returns the LANDFIRE Map Zone(s) a spatial object intersects or the
zone number from the zone name. Currently, only map zones within CONUS are
supported.
}
\examples{
\dontrun{
v <- sf::st_bbox(sf::st_as_sf(data.frame(x = c(-123.7835,-123.6352),
                                        y = c(41.7534,41.8042)),
                             coords = c("x", "y"),
                             crs = 4326)) |>
 sf::st_as_sfc()
zone <- getZone(v)
}

}
