% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_params_from_name_raw}
\alias{get_params_from_name_raw}
\title{Extract Parameter Samples from a Turing.jl MCMCChains Object (internal use only)}
\usage{
get_params_from_name_raw(params, name)
}
\arguments{
\item{params}{A character vector of parameter names (as defined in the Julia model) to extract.}

\item{name}{A character string giving the name of the Julia object in the current Julia session,
which must be a `Chains` object (from the `MCMCChains.jl` package).}
}
\value{
A numeric matrix where rows represent samples and columns represent parameters.
}
\description{
This function extracts posterior samples for specified parameters from a Julia
`Chains` object (from the `Turing.jl` package) using `JuliaCall`.
}
\details{
It supports extracting one or more parameters and returns the result as a numeric matrix in R.


This function builds a Julia expression of the form `Array(chains[:, [:param1, :param2], :])`
to extract values for the specified parameters from the sampler object. The result is evaluated
in Julia and returned to R as a numeric matrix.

The function reshapes the output if only one parameter is extracted to ensure a consistent matrix format.
}
\keyword{internal}
