% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_prob.R
\docType{data}
\name{acc}
\alias{acc}
\alias{accurate}
\alias{correct}
\title{Accuracy (acc) is the probability of a correct decision.}
\format{
An object of class \code{numeric} of length 1.
}
\usage{
acc
}
\description{
\code{acc} defines overall accuracy
as the probability of correspondence between a positive decision
and true condition (i.e., the proportion of correct classification
decisions or of \code{\link{dec_cor}} cases).
}
\details{
Importantly, correct decisions \code{\link{dec_cor}}
are not necessarily positive decisions \code{\link{dec_pos}}.

Understanding or obtaining the accuracy metric \code{acc}:

\itemize{

  \item Definition:
  \code{acc} is the (non-conditional) probability:

  \code{acc = p(dec_cor) = dec_cor/N}

  or the base rate (or baseline probability)
  of a decision being correct, but not necessarily positive.

  \code{acc} values range
  from 0 (no correct decision/prediction)
  to 1 (perfect decision/prediction).

  \item Computation: \code{acc} can be computed in several ways:

   (a) from \code{\link{prob}}: \code{acc = (prev x sens) + [(1 - prev) x spec]}

   (b) from \code{\link{freq}}: \code{acc = dec_cor/N = (hi + cr)/(hi + mi + fa + cr)}

   (c) as complement of the error rate \code{\link{err}}: \code{acc = 1 - err}

   When frequencies in \code{\link{freq}} are not rounded, (b) coincides with (a) and (c).

  \item Perspective:
  \code{acc} classifies a population of \code{\link{N}} individuals
  by accuracy/correspondence (\code{acc = dec_cor/N}).

  \code{acc} is the "by accuracy" or "by correspondence" counterpart
  to \code{\link{prev}} (which adopts a "by condition" perspective) and
  to \code{\link{ppod}} (which adopts a "by decision" perspective).

  \item Alternative names:
  base rate of correct decisions,
  non-erroneous cases

  \item In terms of frequencies,
  \code{acc} is the ratio of
  \code{\link{dec_cor}} (i.e., \code{\link{hi} + \link{cr}})
  divided by \code{\link{N}} (i.e.,
  \code{\link{hi} + \link{mi}} + \code{\link{fa} + \link{cr}}):

  \code{acc = dec_cor/N = (hi + cr)/(hi + mi + fa + cr)}

  \item Dependencies:
  \code{acc} is a feature of both the environment (true condition) and
  of the decision process or diagnostic procedure. It reflects the
  correspondence of decisions to conditions.

}

See \code{\link{accu}} for other accuracy metrics
and several possible interpretations of accuracy.
}
\examples{
acc <- .50     # sets a rate of correct decisions of 50\%
acc <- 50/100  # (dec_cor) for 50 out of 100 individuals
is_prob(acc)   # TRUE

}
\references{
Consult \href{https://en.wikipedia.org/wiki/Accuracy_and_precision}{Wikipedia:Accuracy_and_precision} for additional information.
}
\seealso{
\code{\link{comp_acc}} computes accuracy from probabilities;
\code{\link{accu}} lists all accuracy metrics;
\code{\link{comp_accu_prob}} computes exact accuracy metrics from probabilities;
\code{\link{comp_accu_freq}} computes accuracy metrics from frequencies;
\code{\link{comp_sens}} and \code{\link{comp_PPV}} compute related probabilities;
\code{\link{is_extreme_prob_set}} verifies extreme cases;
\code{\link{comp_complement}} computes a probability's complement;
\code{\link{is_complement}} verifies probability complements;
\code{\link{comp_prob}} computes current probability information;
\code{\link{prob}} contains current probability information;
\code{\link{is_prob}} verifies probabilities.

Other probabilities: 
\code{\link{FDR}},
\code{\link{FOR}},
\code{\link{NPV}},
\code{\link{PPV}},
\code{\link{err}},
\code{\link{fart}},
\code{\link{mirt}},
\code{\link{ppod}},
\code{\link{prev}},
\code{\link{sens}},
\code{\link{spec}}

Other metrics: 
\code{\link{accu}},
\code{\link{comp_acc}()},
\code{\link{comp_accu_freq}()},
\code{\link{comp_accu_prob}()},
\code{\link{comp_err}()},
\code{\link{err}}
}
\concept{metrics}
\concept{probabilities}
\keyword{datasets}
