% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate.R
\name{hpd}
\alias{hpd}
\title{Calculate highest posterior density}
\usage{
hpd(
  calib,
  prob = 0.95,
  return.raw = FALSE,
  BCAD = FALSE,
  ka = FALSE,
  age.round = 0,
  prob.round = 1,
  every = 0.1,
  bins = 20
)
}
\arguments{
\item{calib}{The calibrated distribution, as returned from caldist()}

\item{prob}{Probability range which should be calculated. Default \code{prob=0.95}.}

\item{return.raw}{The raw data to calculate hpds can be returned, e.g. to draw polygons of the calibrated distributions. Defaults to \code{return.raw=FALSE}.}

\item{BCAD}{Which calendar scale to use. Defaults to cal BP, \code{BCAD=FALSE}.}

\item{ka}{Whether to report results in years (default) or as ka}

\item{age.round}{Rounding for ages. Defaults to 0 decimals.}

\item{prob.round}{Rounding for reported probabilities. Defaults to 1 decimal.}

\item{every}{Yearly precision (defaults to 0.1, as a compromise between speed and accuracy).}

\item{bins}{The number of bins required. Any distribution with fewer bins gets recalculated using 100 narrower bins.}
}
\value{
The highest posterior density ranges, as three columns: from age, to age, and the corresponding percentage(s) of the range(s)
}
\description{
Calculate highest posterior density ranges of calibrated distribution
}
\examples{
hpd(caldist(130,20))
plot(tmp <- caldist(2450,50), type='l')
myhpds <- hpd(tmp)
abline(v=unlist(myhpds[,1:2]), col=4)
}
