% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor.R, R/tensor_indices.R
\name{tensor}
\alias{tensor}
\alias{\%_\%}
\title{Create a labeled array (tensor)}
\usage{
tensor(a, index_names, index_positions, call = NULL)

a \%_\% i
}
\arguments{
\item{a}{An array or any object that can be coerced to an array via
\code{\link[=as.array]{as.array()}}.}

\item{index_names}{A character vector of index names / labels.}

\item{index_positions}{A character vector of index positions with two allowed
values "+" and "-", for "upper" and "lower" position respectively.
The length of \code{index_positions} needs to agree with the length of
\code{index_names}.}

\item{call}{For internal use only.}

\item{i}{An index slot label specification created with \code{\link[=.]{.()}}.}
}
\value{
A labeled tensor object of class \code{"tensor"}, an \code{\link[=array]{array()}}
with attached dimension labels. Note that the index structure
of the resulting tensor does not necessarily have to match \code{i}. In case
implicit calculations are already triggered (e.g. contractions)
the index structure reflects the resulting tensor.
}
\description{
Creates a labeled array (tensor) from an array. \verb{\%_\%} and \code{tensor()} serve
the same purpose, but typically usage of \verb{\%_\%} is preferred due to
brevity.
\code{tensor()} is exported to provide a standard-evaluation interface
as well which might be useful under some circumstances.
}
\examples{
a <- array(1:4, dim = c(2, 2))
a \%_\% .(i, j)
}
\concept{tensor}
\concept{tensor_create}
