% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cran-compliance.R
\name{vendor_pkgs}
\alias{vendor_pkgs}
\title{Vendor Rust dependencies}
\usage{
vendor_pkgs(path = ".", quiet = FALSE, overwrite = NULL)
}
\arguments{
\item{path}{File path to the package for which to generate wrapper code.}

\item{quiet}{Logical indicating whether any progress messages should be
generated or not.}

\item{overwrite}{Logical scalar or \code{NULL} indicating whether the files in the \code{path} should be overwritten.
If \code{NULL} (default), the function will ask the user whether each file should
be overwritten in an interactive session or do nothing in a non-interactive session.
If \code{FALSE} and each file already exists, the function will do nothing.
If \code{TRUE}, all files will be overwritten.}
}
\value{
\itemize{
\item \code{vendor_pkgs()} returns a data.frame with two columns \code{crate} and \code{version}
}
}
\description{
\code{vendor_pkgs()} is used to package the dependencies as required by CRAN.
It executes \verb{cargo vendor} on your behalf creating a \verb{vendor/} directory and a
compressed \code{vendor.tar.xz} which will be shipped with package itself.
If you have modified your dependencies, you will need need to repackage
}
\examples{
\dontrun{
vendor_pkgs()
}
}
