% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval.R
\name{rust_eval}
\alias{rust_eval}
\title{Evaluate Rust code}
\usage{
rust_eval(code, env = parent.frame(), ...)
}
\arguments{
\item{code}{Input rust code.}

\item{env}{The R environment in which the Rust code will be evaluated.}

\item{...}{Other parameters handed off to \code{\link[=rust_function]{rust_function()}}.}
}
\value{
The return value generated by the Rust code.
}
\description{
Compile and evaluate one or more Rust expressions. If the last
expression in the Rust code returns a value (i.e., does not end with
\verb{;}), then this value is returned to R. The value returned does not need
to be of type \code{Robj}, as long as it can be cast into this type with
\code{.into()}. This conversion is done automatically, so you don't have to
worry about it in your code.
}
\examples{
\dontrun{
# Rust code without return value, called only for its side effects
rust_eval(
  code = 'rprintln!("hello from Rust!");'
)

# Rust code with return value
rust_eval(
  code = "
    let x = 5;
    let y = 7;
    let z = x * y;
    z // return to R; rust_eval() takes care of type conversion code
 "
)
}
}
