% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redis_tools.R
\name{from_redis_hash}
\alias{from_redis_hash}
\title{Convert Redis hash}
\usage{
from_redis_hash(
  con,
  key,
  fields = NULL,
  f = as.character,
  missing = NA_character_
)
}
\arguments{
\item{con}{A Redis connection object}

\item{key}{key of the hash}

\item{fields}{Optional vector of fields (if absent, all fields are
retrieved via \code{HGETALL}.}

\item{f}{Function to apply to the \code{list} of values retrieved
as a single set.  To apply element-wise, this will need to be
run via something like \code{Vectorize}.}

\item{missing}{What to substitute into the returned vector for
missing elements.  By default an NA will be added.  A
\code{stop} expression is OK and will only be evaluated if
values are missing.}
}
\description{
Convert a Redis hash to a character vector or list.  This tries to
bridge the gap between the way Redis returns hashes and the way
that they are nice to work with in R, but keeping all conversions
very explicit.
}
\examples{
\dontshow{if (redux::redis_available()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Using a random key so we don't overwrite anything in your database:
key <- paste0("redux::", paste(sample(letters, 15), collapse = ""))
r <- redux::hiredis()
r$HSET(key, "a", "apple")
r$HSET(key, "b", "banana")
r$HSET(key, "c", "carrot")

# Now we have a hash with three elements:
r$HGETALL(key)

# Ew, that's not very nice.  This is nicer:
redux::from_redis_hash(r, key)

# If one of the elements was not a string, then that would not
# have worked, but you can always leave as a list:
redux::from_redis_hash(r, key, f = identity)

# To get just some elements:
redux::from_redis_hash(r, key, c("a", "c"))

# And if some are not present:
redux::from_redis_hash(r, key, c("a", "x"))
redux::from_redis_hash(r, key, c("a", "z"), missing = "zebra")

r$DEL(key)
\dontshow{\}) # examplesIf}
}
