% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_kingdoms.R
\name{rl_kingdoms}
\alias{rl_kingdoms}
\title{IUCN Red List taxa by kingdom}
\usage{
rl_kingdoms(
  kingdom_name = NULL,
  year_published = NULL,
  latest = NULL,
  scope_code = NULL,
  page = 1
)
}
\arguments{
\item{kingdom_name}{Character. The kingdom name (e.g., "Animalia").
Use \code{\link[=rl_kingdoms]{rl_kingdoms()}} to list available kingdoms.}

\item{year_published}{Optional. Single or numeric vector of years to filter assessments by publication year.}

\item{latest}{Optional. Logical. If \code{TRUE}, return only the latest assessment per species.}

\item{scope_code}{Optional. Integer One or more scope codes to filter assessments.}

\item{page}{Optional. Integer vector. Specify one or more page numbers to fetch.
If \code{NULL} or \code{NA}, all pages will be fetched automatically.}
}
\value{
A tibble (class \code{tbl_df}, \code{tbl}, \code{data.frame}) where each column represents a unique API response JSON key.
If \code{kingdom_name = NULL}, the tibble contains available kingdom names.
If \code{kingdom_name} is provided, the tibble contains assessment data for the specified kingdom, including taxon details, red list category, year, and
other relevant metadata.
}
\description{
Retrieve species assessments by kingdom.
If \code{kingdom_name = NULL}, it returns a list of available kingdoms.
If \code{kingdom_name} is provided, it retrieves assessments for species in the specified kingdom.
}
\examples{
\dontrun{
# List all available kingdoms
rl_kingdoms()

# Get assessments for species in Animalia kingdom
rl_kingdoms(kingdom_name = "Animalia")

# Get latest assessments for Plantae published in 2021
rl_kingdoms(
  kingdom_name = "Plantae",
  year_published = 2021,
  latest = TRUE
)
}
}
