% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_select_unique.R, R/select_unique.R
\name{select_unique.cluster_pairs}
\alias{select_unique.cluster_pairs}
\alias{select_unique}
\alias{select_unique.pairs}
\title{Deselect pairs that are linked to multiple records}
\usage{
\method{select_unique}{cluster_pairs}(
  pairs,
  variable,
  preselect = NULL,
  n = 1,
  m = 1,
  id_x = NULL,
  id_y = NULL,
  ...
)

select_unique(
  pairs,
  variable,
  preselect = NULL,
  n = 1,
  m = 1,
  id_x = NULL,
  id_y = NULL,
  ...
)

\method{select_unique}{pairs}(
  pairs,
  variable,
  preselect = NULL,
  n = 1,
  m = 1,
  id_x = NULL,
  id_y = NULL,
  x = attr(pairs, "x"),
  y = attr(pairs, "y"),
  inplace = FALSE,
  ...
)
}
\arguments{
\item{pairs}{a \code{pairs} object, such as generated by 
\code{\link{pair_blocking}}}

\item{variable}{the name of the new variable to create in pairs. This will be a
logical variable with a value of \code{TRUE} for the selected pairs.}

\item{preselect}{a logical variable with the same length as \code{pairs} has
rows, or the name of such a variable in \code{pairs}. Pairs are only 
selected when \code{preselect} is \code{TRUE}.}

\item{n}{do not select pairs with a y-record that is linked to more than
\code{n} records.}

\item{m}{do not select pairs with a m-record that is linked to more than
\code{m} records.}

\item{id_x}{a integer vector with the same length as the number of rows in 
\code{pairs}, or the name of a column in \code{x}. This vector should 
identify unique objects in \code{x}. When not specified it is assumed that
each element in \code{x} is unique.}

\item{id_y}{a integer vector with the same length as the number of rows in 
\code{pairs}, or the name of a column in \code{y}. This vector should 
identify unique objects in \code{y}. When not specified it is assumed that
each element in \code{y} is unique.}

\item{...}{Used to pass additional arguments to methods}

\item{x}{\code{data.table} with one half of the pairs.}

\item{y}{\code{data.table} with the other half of the pairs.}

\item{inplace}{logical indicating whether \code{pairs} should be modified in place. When
pairs is large this can be more efficient.}
}
\value{
Returns the \code{pairs} with the variable given by \code{variable} added. This
is a logical variable indicating which pairs are selected as matches.
}
\description{
Deselect pairs that are linked to multiple records
}
\details{
This function can be used to remove pairs for which there is ambiguity. For
example when a record from \code{x} is linked to multiple records from
\code{y} and we know that there are no duplicate records in \code{y} (records
that belong to the same object), then we know that at least on of the two
links is incorrect but we cannot decide which of the two. In that case we may
want to decide that we will not link both records. Running
\code{select_unique} with \code{m == 1} will remove both records.

In case one wants to select one of the records randomly: \code{select_greedy}
will select the pair with the highest weight and in case of an equal weight
the first. Adding a random component to the weights will ensure a random
selection.
}
\examples{
data("linkexample1", "linkexample2")
pairs <- pair_blocking(linkexample1, linkexample2, "postcode")
compare_pairs(pairs, on = c("lastname", "firstname", "address", "sex"),
  default_comparator = jaro_winkler(0.9), inplace = TRUE)
score_simple(pairs, "score", 
  on = c("lastname", "firstname", "address", "sex"),
  w1 = list(lastname = 2), inplace = TRUE)
select_threshold(pairs, variable = "select", 
  score = "score", threshold = 4.0, inplace =  TRUE)
select_unique(pairs, variable = "select_unique", preselect = "select")

}
