% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unicode-general-category-classes.R,
%   R/unicode-general-category-constants.R
\docType{data}
\name{ugc_cased_letter}
\alias{ugc_cased_letter}
\alias{ugc_close_punctuation}
\alias{ugc_connector_punctuation}
\alias{ugc_control}
\alias{ugc_currency_symbol}
\alias{ugc_dash_punctuation}
\alias{ugc_decimal_number}
\alias{ugc_enclosing_mark}
\alias{ugc_final_punctuation}
\alias{ugc_format_control}
\alias{ugc_initial_punctuation}
\alias{ugc_letter}
\alias{ugc_letter_number}
\alias{ugc_line_separator}
\alias{ugc_lowercase_letter}
\alias{ugc_mark}
\alias{ugc_math_symbol}
\alias{ugc_modifier_letter}
\alias{ugc_modifier_symbol}
\alias{ugc_nonspacing_mark}
\alias{ugc_number}
\alias{ugc_open_punctuation}
\alias{ugc_other}
\alias{ugc_other_letter}
\alias{ugc_other_number}
\alias{ugc_other_punctuation}
\alias{ugc_other_symbol}
\alias{ugc_paragraph_separator}
\alias{ugc_private_use_control}
\alias{ugc_punctuation}
\alias{ugc_separator}
\alias{ugc_space_separator}
\alias{ugc_spacing_mark}
\alias{ugc_surrogate_control}
\alias{ugc_symbol}
\alias{ugc_titlecase_letter}
\alias{ugc_unassigned_control}
\alias{ugc_uppercase_letter}
\alias{UnicodeGeneralCategory}
\alias{unicode_general_category}
\alias{UGC_UPPERCASE_LETTER}
\alias{UGC_LOWERCASE_LETTER}
\alias{UGC_TITLECASE_LETTER}
\alias{UGC_CASED_LETTER}
\alias{UGC_MODIFIER_LETTER}
\alias{UGC_OTHER_LETTER}
\alias{UGC_LETTER}
\alias{UGC_NONSPACING_MARK}
\alias{UGC_SPACING_MARK}
\alias{UGC_ENCLOSING_MARK}
\alias{UGC_MARK}
\alias{UGC_DECIMAL_NUMBER}
\alias{UGC_LETTER_NUMBER}
\alias{UGC_OTHER_NUMBER}
\alias{UGC_NUMBER}
\alias{UGC_CONNECTOR_PUNCTUATION}
\alias{UGC_DASH_PUNCTUATION}
\alias{UGC_OPEN_PUNCTUATION}
\alias{UGC_CLOSE_PUNCTUATION}
\alias{UGC_INITIAL_PUNCTUATION}
\alias{UGC_FINAL_PUNCTUATION}
\alias{UGC_OTHER_PUNCTUATION}
\alias{UGC_PUNCTUATION}
\alias{UGC_MATH_SYMBOL}
\alias{UGC_CURRENCY_SYMBOL}
\alias{UGC_MODIFIER_SYMBOL}
\alias{UGC_OTHER_SYMBOL}
\alias{UGC_SYMBOL}
\alias{UGC_SPACE_SEPARATOR}
\alias{UGC_LINE_SEPARATOR}
\alias{UGC_PARAGRAPH_SEPARATOR}
\alias{UGC_SEPARATOR}
\alias{UGC_CONTROL}
\alias{UGC_FORMAT_CONTROL}
\alias{UGC_SURROGATE_CONTROL}
\alias{UGC_PRIVATE_USE_CONTROL}
\alias{UGC_UNASSIGNED_CONTROL}
\alias{UGC_OTHER}
\title{Unicode General Categories}
\format{
An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.

An object of class \code{regex} (inherits from \code{character}) of length 1.
}
\usage{
ugc_cased_letter(lo, hi, char_class = TRUE)

ugc_close_punctuation(lo, hi, char_class = TRUE)

ugc_connector_punctuation(lo, hi, char_class = TRUE)

ugc_control(lo, hi, char_class = TRUE)

ugc_currency_symbol(lo, hi, char_class = TRUE)

ugc_dash_punctuation(lo, hi, char_class = TRUE)

ugc_decimal_number(lo, hi, char_class = TRUE)

ugc_enclosing_mark(lo, hi, char_class = TRUE)

ugc_final_punctuation(lo, hi, char_class = TRUE)

ugc_format_control(lo, hi, char_class = TRUE)

ugc_initial_punctuation(lo, hi, char_class = TRUE)

ugc_letter(lo, hi, char_class = TRUE)

ugc_letter_number(lo, hi, char_class = TRUE)

ugc_line_separator(lo, hi, char_class = TRUE)

ugc_lowercase_letter(lo, hi, char_class = TRUE)

ugc_mark(lo, hi, char_class = TRUE)

ugc_math_symbol(lo, hi, char_class = TRUE)

ugc_modifier_letter(lo, hi, char_class = TRUE)

ugc_modifier_symbol(lo, hi, char_class = TRUE)

ugc_nonspacing_mark(lo, hi, char_class = TRUE)

ugc_number(lo, hi, char_class = TRUE)

ugc_open_punctuation(lo, hi, char_class = TRUE)

ugc_other(lo, hi, char_class = TRUE)

ugc_other_letter(lo, hi, char_class = TRUE)

ugc_other_number(lo, hi, char_class = TRUE)

ugc_other_punctuation(lo, hi, char_class = TRUE)

ugc_other_symbol(lo, hi, char_class = TRUE)

ugc_paragraph_separator(lo, hi, char_class = TRUE)

ugc_private_use_control(lo, hi, char_class = TRUE)

ugc_punctuation(lo, hi, char_class = TRUE)

ugc_separator(lo, hi, char_class = TRUE)

ugc_space_separator(lo, hi, char_class = TRUE)

ugc_spacing_mark(lo, hi, char_class = TRUE)

ugc_surrogate_control(lo, hi, char_class = TRUE)

ugc_symbol(lo, hi, char_class = TRUE)

ugc_titlecase_letter(lo, hi, char_class = TRUE)

ugc_unassigned_control(lo, hi, char_class = TRUE)

ugc_uppercase_letter(lo, hi, char_class = TRUE)

UGC_UPPERCASE_LETTER

UGC_LOWERCASE_LETTER

UGC_TITLECASE_LETTER

UGC_CASED_LETTER

UGC_MODIFIER_LETTER

UGC_OTHER_LETTER

UGC_LETTER

UGC_NONSPACING_MARK

UGC_SPACING_MARK

UGC_ENCLOSING_MARK

UGC_MARK

UGC_DECIMAL_NUMBER

UGC_LETTER_NUMBER

UGC_OTHER_NUMBER

UGC_NUMBER

UGC_CONNECTOR_PUNCTUATION

UGC_DASH_PUNCTUATION

UGC_OPEN_PUNCTUATION

UGC_CLOSE_PUNCTUATION

UGC_INITIAL_PUNCTUATION

UGC_FINAL_PUNCTUATION

UGC_OTHER_PUNCTUATION

UGC_PUNCTUATION

UGC_MATH_SYMBOL

UGC_CURRENCY_SYMBOL

UGC_MODIFIER_SYMBOL

UGC_OTHER_SYMBOL

UGC_SYMBOL

UGC_SPACE_SEPARATOR

UGC_LINE_SEPARATOR

UGC_PARAGRAPH_SEPARATOR

UGC_SEPARATOR

UGC_CONTROL

UGC_FORMAT_CONTROL

UGC_SURROGATE_CONTROL

UGC_PRIVATE_USE_CONTROL

UGC_UNASSIGNED_CONTROL

UGC_OTHER
}
\arguments{
\item{lo}{A non-negative integer. Minimum number of repeats, when grouped.}

\item{hi}{positive integer. Maximum number of repeats, when grouped.}

\item{char_class}{\code{TRUE} or \code{FALSE}. Should the values be wrapped
into a character class?}
}
\value{
A character vector representing part or all of a regular expression.
}
\description{
Match a Unicode General Category.
}
\examples{
# Classes
ugc_lowercase_letter()
ugc_decimal_number()
ugc_paragraph_separator()
ugc_currency_symbol()

# With repetition
ugc_nonspacing_mark(3, 6)
ugc_separator(1, Inf)
ugc_dash_punctuation(0, Inf)

# Without a class wrapper
ugc_titlecase_letter(char_class = FALSE)

# Constants
UGC_UPPERCASE_LETTER
UGC_LETTER_NUMBER
UGC_MATH_SYMBOL
UGC_FORMAT_CONTROL

\dontrun{
# All the Unicode general categories.
# Not run, since it generates lots of output
ls("package:rebus.unicode", pattern = "^ugc")
}

# Usage
library(rebus.base)
x <- "I exchanged $1000 for \u20ac665.41 and \u00a3243.13."
(rx <- capture(ugc_currency_symbol()) \%R\% 
  capture(
    ugc_decimal_number(1, Inf) \%R\%
    optional(group("." \%R\% ugc_decimal_number(2)))
  )
)
stringi::stri_match_all_regex(x, rx)
}
\references{
Table 12 of the Unicode Standard Annex #44 defines the Unicode
General Categories.
\url{http://www.unicode.org/reports/tr44}

You can see which characters are contained in a category by visiting, e.g.,
\url{http://www.fileformat.info/info/unicode/category/Nd/list.htm}
}
\seealso{
\code{\link{unicode_property}}, \code{\link{Unicode}}
}
\keyword{datasets}
