% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mva.R
\name{mva}
\alias{mva}
\title{Multivariate analysis (PCA, PLS, OPLS)}
\usage{
mva(
  X,
  sample_data,
  group_colour = NULL,
  group_shape = NULL,
  plot_title = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{X}{A numeric matrix or data frame of features (e.g., metabolites, genes),
with samples as rows and features as columns.}

\item{sample_data}{A \code{data.frame} containing sample-level data. Row names must match
the sample identifiers in \code{X} and must be also in a column named \code{"sample_id"}.}

\item{group_colour}{Optional. Character colname in \code{sample_data} used for point color mapping.}

\item{group_shape}{Optional. Character colname in \code{sample_data} used for point shape mapping.}

\item{plot_title}{Optional. Character string specifying the plot title.}

\item{verbose}{Logical. If \code{TRUE}, displays progress messages.}

\item{...}{Additional arguments passed to \code{ropls::opls()} (e.g.\verb{predI =}, \verb{orthoI =}).}
}
\value{
A named list with two elements:
\describe{
\item{ropls_obj}{The \code{ropls::opls()} object.}
\item{scores_plot}{A \code{ggplot2::ggplot()} object showing the scores plot.}
}
}
\description{
Performs PCA, PLS, or OPLS using ropls and generates a formatted scores plot
based on the first two components.
}
\details{
The analysis type depends on the \code{...} arguments passed to \code{ropls::opls()}.
}
\examples{
# PCA
if (requireNamespace("ropls", quietly = TRUE)) {
set.seed(123)
mock_X <- matrix(rnorm(40),
                 nrow = 10,
                 dimnames = list(paste0("sample", 1:10),
                                 paste0("feat", 1:4))
                 )

sample_data <- data.frame(
  sample_id = rownames(mock_X),
  group = factor(rep(c("A", "B"), each = 5)),
  batch = factor(rep(1:2, times = 5)),
  row.names = rownames(mock_X),
  stringsAsFactors = FALSE
)

result <- mva(
  X = mock_X,
  sample_data = sample_data,
  group_colour = "group",
  group_shape = "batch",
  plot_title = "Test PCA Plot",
  predI = 2,  # PCA: set components
  verbose = FALSE
)

# PCA plot
result$scores_plot
}

}
\seealso{
\code{\link[ropls:opls]{ropls::opls()}} for details on the \code{ropls::opls()} output.
}
