% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/browse_data.R
\name{browse_rba_series}
\alias{browse_rba_series}
\alias{browse_rba_tables}
\title{Browse available RBA data series}
\usage{
browse_rba_series(search_string = "")

browse_rba_tables(search_string = "", refresh = FALSE)
}
\arguments{
\item{search_string}{Word or phrase to search for, such as "gold" or "commodity" or "labour".
If left as \code{""}, the function will return all series.}

\item{refresh}{logical; \code{FALSE} by default. When \code{FALSE}, internal data is
used. When \code{TRUE}, the RBA website is re-scraped to obtain current information
about available tables This can take a few seconds.}
}
\value{
A \code{data.frame} (\code{tbl_df}) containing RBA data series/tables that match the \code{search_string}.
Where no \code{search_string} is supplied, the data.frame will contain information
about all RBA series/tables.

The data.frame returned by \code{browse_rba_tables()} includes a column called
\code{readable}. This column takes the value \code{TRUE} if the table is able to be
read by \code{read_rba()} and \code{FALSE} if it cannot be read.
}
\description{
Use these functions to find the table number or series ID of the data you're
interested in.
}
\examples{

# Find series that contain 'unemployment'
browse_rba_series("unemployment")

# Or all labour-related series
browse_rba_series("labour")

# Or those related to commodities
browse_rba_series("commodities")

# Or all series
browse_rba_series()

# Or just look for tables that contain the word 'labour'
browse_rba_tables("labour")

# Or all tables
browse_rba_tables()

# To re-scrape the RBA website to ensure you have up-to-date information
# about available tables:
\dontrun{
browse_rba_tables(refresh = TRUE)
}

}
