% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDWD.R
\name{plotDWD}
\alias{plotDWD}
\title{Quickly plot time series}
\usage{
plotDWD(
  x,
  cn,
  monthaxis = TRUE,
  line0 = FALSE,
  xlab = "",
  ylab = cn,
  main = "",
  type = "l",
  lwd = 3,
  col = "blue",
  las = 1,
  mar = c(2.6, 3.1, 2.5, 0.5),
  mgp = c(1.9, 0.7, 0),
  keeppar = TRUE,
  ...
)
}
\arguments{
\item{x}{Data.frame, e.g. from \link{readDWD.data}}

\item{cn}{Column name (charstring)}

\item{monthaxis}{Draw nice axis? DEFAULT: TRUE}

\item{line0}{Draw horizontal line at 0? DEFAULT: FALSE}

\item{xlab}{X axis label. DEFAULT: ""}

\item{ylab}{Y axis label. DEFAULT: cn}

\item{main}{Plot title. DEFAULT: ""}

\item{type}{\link[graphics:plot.default]{graphics::plot} type. DEFAULT: "l"}

\item{lwd}{Line width. DEFAULT: 3}

\item{col}{Line color. DEFAULT: "blue"}

\item{las}{Label axis style. DEFAULT: 1 (all upright)}

\item{mar}{Plot margins. DEFAULT: c(2.6, 3.1, 2.5, 0.5)}

\item{mgp}{Margin placement. DEFAULT: c(1.9, 0.7, 0)}

\item{keeppar}{Keep \verb{las, mar and mgp} as set with \link{par},
so later points are added in the right location?
DEFAULT: TRUE}

\item{\dots}{Further arguments passed to \link[graphics:plot.default]{graphics::plot}}
}
\value{
Nothing
}
\description{
plot rdwd time series from data.frames
}
\examples{
link <- selectDWD("Potsdam", res="daily", var="kl", per="r")
clim <- dataDWD(link, dir=locdir(), varnames=TRUE)
plotDWD(clim, "TMK.Lufttemperatur", line0=TRUE, main="Potsdam")

}
\seealso{
\code{\link[=readDWD]{readDWD()}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Sep 2021
}
\keyword{hplot}
