% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.rd.R
\name{predict.rd}
\alias{predict.rd}
\title{Predict the Regression Discontinuity}
\usage{
\method{predict}{rd}(object, gran = 50, ...)
}
\arguments{
\item{object}{An \code{rd} object, typically the result of \code{\link{rd_est}}.}

\item{gran}{A non-negative integer specifying the granularity of the data points (i.e. the desired number of predicted points). The default is 50.}

\item{...}{Additional arguments passed to \code{predict}.}
}
\description{
\code{predict.rd} makes predictions of means and standard deviations of RDs at different cutoffs.
}
\examples{
set.seed(12345)
x <- runif(1000, -1, 1)
cov <- rnorm(1000)
y <- 3 + 2 * x + 3 * cov + 10 * (x >= 0) + rnorm(1000)
tr <- as.integer(x >= 0)
rd <- rd_est(y ~ x + tr | cov, cutpoint = 0, t.design = "geq") 
predict(rd)
}
