% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.R
\name{add_weights}
\alias{add_weights}
\title{Add weights to the network.}
\usage{
add_weights(
  network,
  target = NULL,
  exclude_area = NULL,
  penalty = 1000,
  weight_name = "weight"
)
}
\arguments{
\item{network}{A network object}

\item{target}{Target geometry to calculate distances from, as a simple
feature geometry}

\item{exclude_area}{Area that we aim to exclude from the shortest-path
search, as a simple feature geometry}

\item{penalty}{Penalty (in the network CRS' units) that is added to the
edges that falls within the excluded area}

\item{weight_name}{Name of the column in the edge table where to add the
weights}
}
\value{
A network object of class \code{\link[sfnetworks:sfnetwork]{sfnetworks::sfnetwork}} with weights
added as a column in the edge table
}
\description{
This is to prepare the network for the search of shortest paths between node
pairs. The computed weights can account for edge lenghts, distance from a
target geometry, and whether or not an edge falls within a specified region,
which we aim to exclude from search of the shortest paths.
}
\details{
For the i-th edge of the network, its weight \eqn{w_i} is defined in the
following way:
\deqn{
 w_i = |e_i| + d_{geom}(e_i) + p_{buf}(e_i)
}{wi = |ei| + d(geom, ei) + p(buffer, ei)}
where the first term is the edge length, the second one is the distance
from a target geometry (\code{target}, optional) and the last one is a penalty
that is added if the centroid of the edge falls within a specified region
(\code{exclude_area}, optional).

Shortest paths calculated on the resulting network will thus tend to prefer
edges close to \code{target} and to avoid edges within \code{exclude_area}.
}
\keyword{internal}
