% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family-distgrid.R, R/op-cdo-distgrid.R
\name{distgrid}
\alias{distgrid}
\alias{cdo_distgrid}
\title{Distribute horizontal grid}
\usage{
cdo_distgrid(ifile, nx = NULL, ny = NULL, obase = NULL)
}
\arguments{
\item{ifile}{String with the path to the input file.}

\item{nx}{INTEGER - Number of regions in x direction, or number of pieces for unstructured grids}

\item{ny}{INTEGER - Number of regions in y direction [default: 1]}

\item{obase}{String with the basename of the output files.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operatos that don't return filenames return a character vector with the
string output.
}
\description{
This operator distributes a dataset into smaller pieces. Each output file contains a different region of the horizontal source grid. 2D Lon/Lat grids can be split into nx*ny pieces, where a target grid region contains a structured longitude/latitude box of the source grid. Data on an unstructured grid is split into nx pieces. The output files will be named <obase><xxx><suffix> where suffix is the filename extension derived from the file format. xxx will have five digits with the number of the target region.
}
\section{Note}{

This operator needs to open all output files simultaneously. The maximum number of open files depends on the operating system!
}

