% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_rcdf_as.R
\name{write_rcdf_json}
\alias{write_rcdf_json}
\title{Write RCDF data to JSON files}
\usage{
write_rcdf_json(data, path, ..., parent_dir = NULL)
}
\arguments{
\item{data}{A valid RCDF object.}

\item{path}{The output directory for files.}

\item{...}{Additional arguments passed to `jsonlite::write_json()`.}

\item{parent_dir}{Optional subdirectory under `path` to group JSON files.}
}
\value{
Invisibly returns `NULL`. Files are written to disk.
}
\description{
Writes each table in the RCDF object as a separate `.json` file.
}
\examples{
dir <- system.file("extdata", package = "rcdf")
rcdf_path <- file.path(dir, 'mtcars.rcdf')
private_key <- file.path(dir, 'sample-private-key.pem')

rcdf_data <- read_rcdf(path = rcdf_path, decryption_key = private_key)
temp_dir <- tempdir()

write_rcdf_json(data = rcdf_data, path = temp_dir)

unlink(temp_dir, force = TRUE)
}
\seealso{
\link[rcdf]{write_rcdf_as}
}
