% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ring_segmentation.R
\name{ring_segmentation}
\alias{ring_segmentation}
\title{Assign zenith-ring labels}
\usage{
ring_segmentation(z, angle_width, return = "id")
}
\arguments{
\item{z}{\link[terra:SpatRaster-class]{terra::SpatRaster} generated with \code{\link[=zenith_image]{zenith_image()}}.}

\item{angle_width}{numeric vector of length one. Ring width in degrees.
Must divide the 0-90 deg range into an integer number of segments.}

\item{return}{character vector of length one. Output mode: "id" (default)
or "angle".}
}
\value{
Single-layer \link[terra:SpatRaster-class]{terra::SpatRaster}: ring IDs if \code{return = "id"},
or mean zenith angle (deg) if \code{return = "angle"}.
}
\description{
Segment a hemispherical view into concentric rings by slicing the zenith
angle from \code{0} to \code{90} deg at equal steps.
}
\examples{
z <- zenith_image(600, lens())
rings <- ring_segmentation(z, 15)
plot(rings == 1)
}
