% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize_minmax.R
\name{normalize_minmax}
\alias{normalize_minmax}
\title{Normalize data using min-max rescaling}
\usage{
normalize_minmax(r, mn = NULL, mx = NULL, clip = FALSE)
}
\arguments{
\item{r}{numeric \link[terra:SpatRaster-class]{terra::SpatRaster} or numeric vector. Input data.}

\item{mn}{numeric vector of length one or \code{NULL}. Minimum expected value.
If \code{NULL} (default), uses the minimum of \code{r}.}

\item{mx}{numeric vector of length one or \code{NULL}. Maximum expected value.
If \code{NULL} (default), uses the maximum of \code{r}.}

\item{clip}{logical vector of length one. If \code{TRUE}, clip the output to
\eqn{[0, 1]} after rescaling. If \code{FALSE}, values greater than \code{mx} are scaled
proportionally to values above \code{1}, and values less than \code{mn} to values
below \code{0}.}
}
\value{
Same properties as \code{r}, with values rescaled to the range \eqn{[0, 1]} if
\code{mn} and \code{mx} match the range of \code{r} or extend beyond it. If \code{clip = TRUE},
values will be within \eqn{[0, 1]} even if this implies data loss.
}
\description{
Rescale numeric or raster data from an expected range to the range \eqn{[0, 1]}.
}
\examples{
normalize_minmax(read_caim())
}
