% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomes.R
\name{Biomes}
\alias{Biomes}
\alias{get_biomes_value}
\alias{get_biomes_data}
\alias{put_biomes_value}
\alias{put_biomes_data}
\alias{biome_id}
\alias{biome_name}
\title{Read and write Biomes data}
\usage{
get_biomes_value(x, z, dimension, db = default_db(), return_names = TRUE)

get_biomes_data(x, z, dimension, db = default_db(), return_names = TRUE)

put_biomes_value(
  value,
  x,
  z,
  dimension,
  db = default_db(),
  missing_height = 0L
)

put_biomes_data(
  values,
  x,
  z,
  dimension,
  db = default_db(),
  missing_height = 0L
)

biome_id(value)

biome_name(value)
}
\arguments{
\item{x, z, dimension}{Chunk coordinates to extract data from.
\code{x} can also be a character vector of db keys.}

\item{db}{A bedrockdb object.}

\item{return_names}{return biome names instead of biome ids.}

\item{value}{An array of biome ids.}

\item{missing_height}{if there is no existing height data, use this value
for the chunk.}

\item{values}{A (named) list of Biomes data values. If \code{x} is missing, the
names of \code{values} will be taken as the keys.}
}
\value{
\code{get_biomes_value()} returns a Biomes data value.
\code{get_biomes_data()} returns a named list of Biomes data values.
Biomes data values are 16x384x16 arrays containing biome data.
}
\description{
Biomes data is stored as the second map in the \link{Data3D} data (tag 43).
}
\details{
\itemize{
\item \code{get_biomes_value()} and \code{get_biomes_data()} load Biomes data from \code{db}.
\code{get_biomes_value()} loads data for a single chunk, and \code{get_biomes_data()}
loads data for multiple chunks.
\item \code{put_biomes_value()} and \code{put_biomes_data()} store biomes data into \code{db}.
}
}
\seealso{
LegacyBiomes
}
