% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scraper-yc.R
\name{yc_xxx_get}
\alias{yc_xxx_get}
\alias{yc_get}
\alias{yc_brl_get}
\alias{yc_ipca_get}
\alias{yc_usd_get}
\title{Retrieve Yield Curve Data}
\usage{
yc_get()

yc_brl_get()

yc_ipca_get()

yc_usd_get()
}
\value{
An \code{arrow_dplyr_query} or \code{ArrowObject}, representing a lazily evaluated query. The underlying data is not
collected until explicitly requested, allowing efficient manipulation of large datasets without immediate
memory usage.
To trigger evaluation and return the results as an R \code{tibble}, use \code{collect()}.

The returned data includes the following columns:
\itemize{
\item \code{curve_name}: Identifier of the yield curve (e.g., "PRE", "DOC", "DIC").
\item \code{refdate}: Reference date of the curve.
\item \code{forward_date}: Maturity date associated with the interest rate.
\item \code{biz_days}: Number of business days between \code{refdate} and \code{forward_date}.
\item \code{cur_days}: Number of calendar days between \code{refdate} and \code{forward_date}.
\item \code{r_252}: Annualized interest rate based on 252 business days.
\item \code{r_360}: Annualized interest rate based on 360 calendar days.
}
}
\description{
These functions retrieve yield curve data, either for all available curves (\code{yc_get}) or
specifically for:
\itemize{
\item the nominal rates curve (\code{yc_brl_get}).
\item the nominal rates curve for USD in Brazil - Cupom Cambial Limpo (\code{yc_usd_get}).
\item the real rates curve (\code{yc_ipca_get}).
}
}
\details{
The yield curve data is downloaded from the B3 website
\url{https://www2.bmf.com.br/pages/portal/bmfbovespa/lumis/lum-taxas-referenciais-bmf-ptBR.asp}.
See the Curve Manual in this link
\url{https://www.b3.com.br/data/files/8B/F5/11/68/5391F61043E561F6AC094EA8/Manual_de_Curvas.pdf}
for more details.
}
\examples{
\dontrun{
df <- yc_get() |>
  filter(curve_name == "PRE") |>
  collect()
}
\dontrun{
df_yc <- yc_brl_get() |>
  filter(refdate == Sys.Date()) |>
  collect()
head(df_yc)
}
\dontrun{
df_yc_ipca <- yc_ipca_get() |>
  filter(refdate == Sys.Date()) |>
  collect()
head(df_yc_ipca)
}
\dontrun{
df_yc_usd <- yc_usd_get() |>
  filter(refdate == Sys.Date()) |>
  collect()
head(df_yc_usd)
}
}
