% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scraper-cotahist.R, R/scraper-yc.R
\name{superdataset}
\alias{superdataset}
\alias{cotahist_options_by_symbols_get}
\alias{yc_brl_with_futures_get}
\alias{yc_usd_with_futures_get}
\alias{yc_ipca_with_futures_get}
\title{Enhanced Dataset Creation}
\usage{
cotahist_options_by_symbols_get(symbols)

yc_brl_with_futures_get(refdate)

yc_usd_with_futures_get(refdate)

yc_ipca_with_futures_get(refdate)
}
\arguments{
\item{symbols}{list of symbols to extract market data from the COTAHIST dataset.}

\item{refdate}{A Date object specifying the reference date for which to retrieve data}
}
\value{
The function \code{cotahist_options_by_symbol_superset()} return an object that inherits from a \code{arrow_dplyr_query}
since it tries to preserve the lazy evaluation and avoids collecting the data before its return.

The functions \code{yc_brl_with_futures_get()}, \code{yc_usd_with_futures_get()} and \code{yc_ipca_with_futures_get()} return
a \code{data.frame} containing the yield curve data merged with futures contract information.
The data is pre-collected (not lazy) and includes all columns from the respective yield curve
function plus a \code{symbol} column identifying the corresponding futures contract.
}
\description{
To maximize the utility of B3's existing datasets, several functions integrate data from multiple
sources to generate specialized datasets for specific analytical needs. For instance,
\code{cotahist_equity_options_superset()} combines data from COTAHIST datasets
(\code{b3-cotahist-yearly}, \code{b3-cotahist-monthly}, and \code{b3-cotahist-daily}) and Reference Rates
(\code{b3-reference-rates}) to construct a dataset containing stock options data. This dataset
includes details such as the closing price of the underlying stock, its ticker symbol, and the
applicable interest rate at option expiration. This comprehensive data enables users to perform
option pricing and calculate implied volatility.
}
\details{
The functions \code{cotahist_equity_options_superset()}, \code{cotahist_funds_options_superset()},
\code{cotahist_index_options_superset()}, and \code{cotahist_options_by_symbol_superset()} use
information from the COTAHIST datasets (\code{b3-cotahist-yearly}, \code{b3-cotahist-monthly},
and \code{b3-cotahist-daily}) and Reference Rates (\code{b3-reference-rates}) and return a dataframe
containing stock option data, including the closing price of the underlying stocks, the ticker
of the underlying asset, and the interest rate at the option's expiration. The returned dataframe
contains the following columns: "refdate", "symbol", "type", "symbol_underlying",
"strike_price", "maturity_date", "r_252", "close", "close_underlying", "volume",
"trade_quantity", and "traded_contracts".

\code{cotahist_options_by_symbol_superset()} returns the same dataset but filtered for the specified asset ticker.

Returned objects preserve lazy evaluation whenever possible and avoid being
collected until the last possible moment. Exceptions occur when operations
cannot be performed using Arrow's operators — in such cases, data will be
collected and \code{data.frame}s will be returned. Please refer to the documentation
to identify the situations where this behavior applies.

These functions retrieve yield curve data merged with corresponding futures contract information:
\itemize{
\item \code{yc_brl_with_futures_get()}: BRL nominal rates with DI1 futures contracts
\item \code{yc_usd_with_futures_get()}: USD rates (Cupom Cambial) with DDI futures contracts
\item \code{yc_ipca_with_futures_get()}: Real (inflation-indexed) rates with DAP futures contracts
}

These functions combine data from B3 Reference Rates (\code{b3-reference-rates}) and
Futures Settlement Prices (\code{b3-futures-settlement-prices}) to create comprehensive yield curve datasets.
The resulting data highlights key vertices along the curve with their corresponding futures contracts,
providing insight into the term structure of interest rates.

Each function requires a specific reference date to prevent excessive memory usage and
ensure optimal performance.
}
\examples{
\dontrun{
date <- preceding(Sys.Date() - 1, "Brazil/ANBIMA")
bova_options <- cotahist_options_by_symbols_get("BOVA11") |> filter(refdate == date)
petr_options <- cotahist_options_by_symbols_get(c("PETR4", "PETR3")) |> filter(refdate == date)
}

\dontrun{
# Get data for the last business day
date <- preceding(Sys.Date() - 1, "Brazil/ANBIMA")

# Retrieve BRL yield curve with DI1 futures
brl_curve <- yc_brl_with_futures_get(date)
head(brl_curve)

# Retrieve USD yield curve with DDI futures
usd_curve <- yc_usd_with_futures_get(date)

# Retrieve inflation-indexed yield curve with DAP futures
ipca_curve <- yc_ipca_with_futures_get(date)
}

}
