% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcg.R
\name{vcg_uniform_remesh}
\alias{vcg_uniform_remesh}
\title{Sample a surface mesh uniformly}
\usage{
vcg_uniform_remesh(
  x,
  voxel_size = NULL,
  offset = 0,
  discretize = FALSE,
  multi_sample = FALSE,
  absolute_distance = FALSE,
  merge_clost = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{x}{surface}

\item{voxel_size}{'voxel' size for space 'discretization'}

\item{offset}{offset position shift of the new surface from the input}

\item{discretize}{whether to use step function (\code{TRUE}) instead of
linear interpolation (\code{FALSE}) to calculate the position of the
intersected edge of the marching cube; default is \code{FALSE}}

\item{multi_sample}{whether to calculate multiple samples for more accurate
results (at the expense of more computing time) to remove artifacts; default
is \code{FALSE}}

\item{absolute_distance}{whether an unsigned distance field should be
computed. When set to \code{TRUE}, non-zero offsets is to be set, and
double-surfaces will be built around the original surface, like a sandwich.}

\item{merge_clost}{whether to merge close vertices; default is \code{TRUE}}

\item{verbose}{whether to verbose the progress; default is \code{TRUE}}
}
\value{
A triangular mesh of class \code{'mesh3d'}
}
\description{
Sample a surface mesh uniformly
}
\examples{

sphere <- vcg_sphere()
mesh <- vcg_uniform_remesh(sphere, voxel_size = 0.45)

if(is_not_cran()) {

rgl_view({

  rgl_call("mfrow3d", 1, 2)

  rgl_call("title3d", "Input")
  rgl_call("wire3d", sphere, col = 2)
  rgl_call("next3d")

  rgl_call("title3d", "Re-meshed to 0.1mm edge distance")
  rgl_call("wire3d", mesh, col = 3)
})

}

}
