% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcg.R
\name{vcg_isosurface}
\alias{vcg_isosurface}
\title{Create surface mesh from 3D-array}
\usage{
vcg_isosurface(
  volume,
  threshold_lb = 0,
  threshold_ub = NA,
  vox_to_ras = diag(c(-1, -1, 1, 1))
)
}
\arguments{
\item{volume}{a volume or a mask volume}

\item{threshold_lb}{lower-bound threshold for creating the surface; default
is \code{0}}

\item{threshold_ub}{upper-bound threshold for creating the surface; default
is \code{NA} (no upper-bound)}

\item{vox_to_ras}{a \code{4x4} \code{'affine'} transform matrix indicating the
'voxel'-to-world transform.}
}
\value{
A triangular mesh of class \code{'mesh3d'}
}
\description{
Create surface from 3D-array using marching cubes algorithm
}
\examples{


if(is_not_cran()) {

library(ravetools)
data("left_hippocampus_mask")

mesh <- vcg_isosurface(left_hippocampus_mask)


rgl_view({

  rgl_call("mfrow3d", 1, 2)

  rgl_call("title3d", "Direct ISOSurface")
  rgl_call("shade3d", mesh, col = 2)

  rgl_call("next3d")
  rgl_call("title3d", "ISOSurface + Implicit Smooth")

  rgl_call("shade3d",
           vcg_smooth_implicit(mesh, degree = 2),
           col = 3)
})

}
}
