% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter-fir.R
\name{fir1}
\alias{fir1}
\title{Window-based \code{FIR} filter design}
\usage{
fir1(
  n,
  w,
  type = c("low", "high", "stop", "pass", "DC-0", "DC-1"),
  window = hamming,
  scale = TRUE,
  hilbert = FALSE
)
}
\arguments{
\item{n}{filter order}

\item{w}{band edges, non-decreasing vector in the range 0 to 1, where 1 is
the \code{Nyquist} frequency. A scalar for high-pass or low-pass filters,
a vector pair for band-pass or band-stop, or a vector for an
alternating pass/stop filter.}

\item{type}{type of the filter, one of \code{"low"} for a low-pass filter,
\code{"high"} for a high-pass filter, \code{"stop"} for a stop-band
(band-reject) filter, \code{"pass"} for a pass-band filter, \code{"DC-0"}
for a band-pass as the first band of a multi-band filter, or \code{"DC-1"}
for a band-stop as the first band of a multi-band filter; default \code{"low"}}

\item{window}{smoothing window function or a numerical vector. The filter is
the same shape as the smoothing window. When \code{window} is a function,
\code{window(n+1)} will be called, otherwise the length of the window
vector needs to have length of \code{n+1}; default: \code{hamming}}

\item{scale}{whether to scale the filter; default is true}

\item{hilbert}{whether to use 'Hilbert' transformer; default is false}
}
\value{
The \code{FIR} filter coefficients with class \code{'Arma'}.
The moving average coefficient is a vector of length \code{n+1}.
}
\description{
Generate a \code{fir1} filter that is checked against \code{Matlab}
\code{fir1} function.
}
