% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imaging-fill-surface.R
\name{fill_surface}
\alias{fill_surface}
\title{Fill a volume cube based on water-tight surface}
\usage{
fill_surface(
  surface,
  inflate = 0,
  IJK2RAS = NULL,
  preview = FALSE,
  preview_frame = 128
)
}
\arguments{
\item{surface}{a surface mesh, can be mesh objects from \code{rgl} or
\code{freesurferformats} packages}

\item{inflate}{amount of 'voxels' to inflate on the final result; must be
a non-negative integer. A zero \code{inflate} value means the resulting
volume is tightly close to the surface}

\item{IJK2RAS}{volume 'IJK' (zero-indexed coordinate index) to
\code{'tkrRAS'} transform, default is automatically determined
leave it `NULL` if you don't know how to set it}

\item{preview}{whether to preview the results; default is false}

\item{preview_frame}{integer from 1 to 256 the depth frame used to generate
preview.}
}
\value{
A list containing the filled volume and parameters used to generate
the volume
}
\description{
Create a cube volume (\code{256} 'voxels' on each margin), fill
in the 'voxels' that are inside of the surface.
}
\details{
This function creates a volume (256 on each margin) and fill in
the volume from a surface mesh. The surface vertex points will be embedded
into the volume first. These points may not be connected together, hence
for each 'voxel', a cube patch will be applied to grow the volume. Then,
the volume will be bucket-filled from a corner, forming a negated mask of
"outside-of-surface" area. The inverted bucket-filled volume is then shrunk
so the mask boundary tightly fits the surface
}
\examples{

\donttest{

# takes > 5s to run example

# Generate a sphere
surface <- vcg_sphere()
surface$vb[1:3, ] <- surface$vb[1:3, ] * 50

fill_surface(surface, preview = TRUE)

}

}
\author{
Zhengjia Wang
}
