% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class012-rave_brain.R
\name{rave_brain}
\alias{rave_brain}
\title{Load 'FreeSurfer' brain from 'RAVE'}
\usage{
rave_brain(
  subject,
  surfaces = "pial",
  overlays = "aparc.a2009s+aseg",
  annotations = "label/aparc.a2009s",
  ...,
  usetemplateifmissing = FALSE,
  include_electrodes = TRUE
)
}
\arguments{
\item{subject}{character, list, or \code{\link{RAVESubject}} instance; for
list or other objects, make sure \code{subject$subject_id} is a valid 'RAVE'
subject 'ID'}

\item{surfaces}{one or more brain surface types from \code{"pial"},
\code{"white"}, \code{"smoothwm"}, \code{"pial-outer-smoothed"}, etc.;
check \code{\link[threeBrain]{threeBrain}}}

\item{overlays}{volumes to overlay; default is \code{'aparc.a2009s+aseg'}}

\item{annotations}{surface annotation or curvature data to load;
default is \code{'label/aparc.a2009s'}, referring to the
\code{'*h.aparc.a2009s.annot'} under the label folder.}

\item{...}{ignored, reserved for legacy code}

\item{usetemplateifmissing}{whether to use template brain when the subject
brain files are missing. If set to true, then a template (usually 'N27')
brain will be displayed as an alternative solution, and electrodes will be
rendered according to their \code{'MNI305'} coordinates, or
\code{'VertexNumber'} if given.}

\item{include_electrodes}{whether to include electrode in the model; default
is true}
}
\value{
A \code{'threeBrain'} instance if brain is found or
\code{usetemplateifmissing} is set to true; otherwise returns \code{NULL}
}
\description{
Create 3D visualization of the brain and visualize with
modern web browsers
}
\examples{


if(has_rave_subject("demo/DemoSubject")) {

  brain <- rave_brain("demo/DemoSubject")

  if(interactive()) {

    brain$plot()

  }

}


}
