% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rater_fit_class.R
\name{summary.mcmc_fit}
\alias{summary.mcmc_fit}
\title{Summarise a \code{mcmc_fit} object}
\usage{
\method{summary}{mcmc_fit}(object, n_pars = 8, ...)
}
\arguments{
\item{object}{An object of class \code{mcmc_fit}.}

\item{n_pars}{The number of pi/theta parameters and z 'items' to display.}

\item{...}{Other arguments passed to function.}
}
\description{
Summarise a \code{mcmc_fit} object
}
\details{
For the class conditional model the 'full' theta parameterisation
(i.e. appearing to have the same number of parameters as the standard
Dawid-Skene model) is calculated and returned. This is designed to allow
easier comparison with the full Dawid-Skene model.
}
\examples{
\donttest{

fit <- rater(anesthesia, "dawid_skene", verbose = FALSE)

summary(fit)

}

}
