% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hill.R
\name{Hill}
\alias{Hill}
\title{Hill's index of diversity - Hill numbers (D)}
\usage{
Hill(
  x,
  window = 3,
  alpha = 1,
  base = exp(1),
  rasterOut = TRUE,
  np = 1,
  na.tolerance = 1,
  cluster.type = "SOCK",
  debugging = FALSE
)
}
\arguments{
\item{x}{Input data may be a matrix, a Spatial Grid Data Frame, a SpatRaster, or a list of these objects. In the latter case, only the first element of the list will be considered.}

\item{window}{The side of the square moving window. It must be an odd numeric value greater than 1 to ensure that the target pixel is in the centre of the moving window. Default value is 3.}

\item{alpha}{Order of the Hill number to compute the index. If \code{alpha} is a vector with length greater than 1, then the index will be calculated over \code{x} for each value in the sequence.}

\item{base}{The logarithm base for the calculation, default is natural logarithm.}

\item{rasterOut}{Boolean; if TRUE, the output will be in SpatRaster format with \code{x} as the template.}

\item{np}{The number of processes (cores) which will be spawned. Default value is 1.}

\item{na.tolerance}{A numeric value between 0.0 and 1.0, which indicates the proportion of NA values that will be tolerated to calculate Hill's index in each moving window over \code{x}. If the relative proportion of NA's in a moving window is bigger than na.tolerance, then the value of the window will be set as NA; otherwise, Hill's index will be calculated considering the non-NA values. Default value is 1.0 (i.e., full tolerance for NA's).}

\item{cluster.type}{The type of cluster which will be created. Options are "MPI" (calls "makeMPIcluster"), "FORK," and "SOCK" (call "makeCluster"). Default type is "SOCK".}

\item{debugging}{A boolean variable set to FALSE by default. If TRUE, additional messages will be printed for debugging purposes.}
}
\value{
A list of matrices of dimension \code{dim(x)} with length equal to the length of \code{alpha}.
}
\description{
Computes Hill's index of diversity (Hill numbers) on different classes of numeric matrices using a moving window algorithm.
}
\details{
Hill numbers (\eqn{{}^qD}) are calculated on numerical matrices as \eqn{{}^qD = (\sum_{i=1}^{R} {p^q}_i)^{1/(1-q)}}, where \emph{q} is the order of the Hill number, \emph{R} is the total number of categories (i.e., unique numerical values in a numerical matrix), and \emph{p} is the relative abundance of each category. When q=1, Shannon.R is called to calculate \eqn{exp(H^1)} instead of the indefinite \eqn{{}^1D}. If \eqn{q > 2*10^9}, BergerParker.R is called to calculate \eqn{1/{{}^\infty D}}. Hill numbers of low order weight more rare categories, whereas Hill numbers of higher order weight more dominant categories.
}
\note{
Linux users need to install libopenmpi for MPI parallel computing. Linux Ubuntu users may try:
\code{apt-get update; apt-get upgrade; apt-get install mpi; apt-get install libopenmpi-dev; apt-get install r-cran-rmpi}

Microsoft Windows users may need some additional work to use "MPI". For more details, see:
\url{https://bioinfomagician.wordpress.com/2013/11/18/installing-rmpi-mpi-for-r-on-mac-and-windows/}
}
\examples{
# Minimal example; compute Hill's index with alpha 1:5 
a <- matrix(c(10,10,10,20,20,20,20,30,30),ncol=3,nrow=3)
hill <- Hill(x=a,window=3,alpha=1:5)

}
\references{
Hill, M.O. (1973). Diversity and evenness: a unifying notation and its consequences. Ecology 54, 427-432.
}
\seealso{
\code{\link{BergerParker}}, \code{\link{Shannon}}
}
