#' Get All Campaigns
#'
#' @param org_id The value is your orgId.
#'
#' @returns tibble with campaigns
#' @export
#' @examples
#' \dontrun{
#' camp <- apl_get_campaigns(org_id = 2623170)
#'}
apl_get_campaigns <- function(org_id = apl_get_me_details()$parentOrgId) {

  result <- apl_make_request(
    endpoint = 'campaigns',
    org_id   = org_id,
    parser   = apl_parsers$campaigns
  )

  return(result)

}
