% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downsample.R
\name{dspc}
\alias{dspc}
\title{Add downsampling index to rppca object}
\usage{
dspc(pc, to = 10000)
}
\arguments{
\item{pc}{an object of class rppca}

\item{to}{The down-sampling parameter. A numeric > 0 or a vector or NA. Interpreted
as a proportion or integer or a index vector, see details.}
}
\value{
An (invisible) object of class \code{rppca} with a slot \code{ds} added.
}
\description{
This index is used by plot.rppca to downsample the col (colour) values. It
is stored in the rppca object's ds slot.
}
\details{
The parameter \code{to} is used to specify and possibly which individuals are sampled.
If NA, all individuals are retained. If \code{to} is of length one and is between 0 and 1,
then it is interpreted as a proportion. If it is greater than 1, it is taken to be
the number of individuals to be sampled (possibly rounded by \code{sample.int}). If
\code{to} is a logical or an integer vector, it is used for logical or integer indexing, respectively.
The integer indices of the sample individuals are written to the \code{ds} slot.
If \code{ds} exists, it is overwritten with a warning.
}
