% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/limit.R
\name{trimramp}
\alias{trimramp}
\title{Trimming a calibrated color ramp object.}
\usage{
trimramp(x, low = NULL, high = NULL)
}
\arguments{
\item{x}{A calibrated color ramp (e.g. \code{calibramp}-class object.}

\item{low}{A single \code{numeric} value, the minimum value in the calibrated ramp.}

\item{high}{A single \code{numeric} value, the maximum value in the calibrated ramp.}
}
\value{
A trimmed version of \code{x}, another \code{calibramp}-class object.
}
\description{
Modify the minimum and maximum values in a \code{calibramp}-class object produced by the \code{\link{expand}} function.
}
\examples{
data(paleomap)
trimmed <- trimramp(paleomap, low=-500, high=1500)
plot(trimmed)
}
