% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paragraphs_scrap.R
\name{paragraphs_scrap}
\alias{paragraphs_scrap}
\title{Website text paragraph scraping}
\usage{
paragraphs_scrap(
  link,
  contain = NULL,
  case_sensitive = FALSE,
  collapse = FALSE,
  askRobot = FALSE
)
}
\arguments{
\item{link}{the link of the web page to scrape}

\item{contain}{filter the paragraphs according to the character string provided.}

\item{case_sensitive}{logical. Should the contain argument be case sensitive ? defaults to FALSE}

\item{collapse}{if TRUE the paragraphs will be collapsed into one element and the contain argument ignored.}

\item{askRobot}{logical. Should the function ask the robots.txt if we're allowed or not to scrap the web page ? Default is FALSE.}
}
\value{
a character vector.
}
\description{
This function is used to scrape text paragraphs from a website.
}
\examples{
\donttest{
# Extracting the paragraphs displayed on the health page of the New York Times

link     <- "https://www.nytimes.com/section/health"

paragraphs_scrap(link)}

}
