% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulater.R
\name{sim_summary}
\alias{sim_summary}
\title{Print simulation summary}
\usage{
sim_summary(dataset, dc = get_class(dataset), fun = "", dec = 4)
}
\arguments{
\item{dataset}{Simulated data}

\item{dc}{Variable classes}

\item{fun}{Summary function to apply}

\item{dec}{Number of decimals to show}
}
\description{
Print simulation summary
}
\examples{
simulater(
  const = "cost 3",
  norm = "demand 2000 1000",
  discrete = "price 5 8 .3 .7",
  form = c("profit = demand * (price - cost)", "profit5K = profit > 5000"),
  seed = 1234
) \%>\% sim_summary()

}
\seealso{
\code{\link{simulater}} to run a simulation

\code{\link{repeater}} to run a repeated simulation
}
