% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnl.R
\name{plot.mnl}
\alias{plot.mnl}
\title{Plot method for the mnl function}
\usage{
\method{plot}{mnl}(
  x,
  plots = "coef",
  conf_lev = 0.95,
  intercept = FALSE,
  nrobs = -1,
  shiny = FALSE,
  custom = FALSE,
  ...
)
}
\arguments{
\item{x}{Return value from \code{\link{mnl}}}

\item{plots}{Plots to produce for the specified MNL model. Use "" to avoid showing any plots (default). "dist" shows histograms (or frequency bar plots) of all variables in the model. "scatter" shows scatter plots (or box plots for factors) for the response variable with each explanatory variable. "coef" provides a coefficient plot}

\item{conf_lev}{Confidence level to use for coefficient and relative risk ratios (RRRs) intervals (.95 is the default)}

\item{intercept}{Include the intercept in the coefficient plot (TRUE or FALSE). FALSE is the default}

\item{nrobs}{Number of data points to show in scatter plots (-1 for all)}

\item{shiny}{Did the function call originate inside a shiny app}

\item{custom}{Logical (TRUE, FALSE) to indicate if ggplot object (or list of ggplot objects) should be returned. This option can be used to customize plots (e.g., add a title, change x and y labels, etc.). See examples and \url{https://ggplot2.tidyverse.org} for options.}

\item{...}{further arguments passed to or from other methods}
}
\description{
Plot method for the mnl function
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/mnl.html} for an example in Radiant
}
\examples{
result <- mnl(
  ketchup,
  rvar = "choice",
  evar = c("price.heinz28", "price.heinz32", "price.heinz41", "price.hunts32"),
  lev = "heinz28"
)
plot(result, plots = "coef")

}
\seealso{
\code{\link{mnl}} to generate results

\code{\link{predict.mnl}} to generate predictions

\code{\link{plot.model.predict}} to plot prediction output
}
