% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crtree.R
\name{cv.crtree}
\alias{cv.crtree}
\title{Cross-validation for Classification and Regression Trees}
\usage{
cv.crtree(
  object,
  K = 5,
  repeats = 1,
  cp,
  pcp = seq(0, 0.01, length.out = 11),
  seed = 1234,
  trace = TRUE,
  fun,
  ...
)
}
\arguments{
\item{object}{Object of type "rpart" or "crtree" to use as a starting point for cross validation}

\item{K}{Number of cross validation passes to use}

\item{repeats}{Number of times to repeat the K cross-validation steps}

\item{cp}{Complexity parameter used when building the (e.g., 0.0001)}

\item{pcp}{Complexity parameter to use for pruning}

\item{seed}{Random seed to use as the starting point}

\item{trace}{Print progress}

\item{fun}{Function to use for model evaluation (e.g., auc for classification or RMSE for regression)}

\item{...}{Additional arguments to be passed to 'fun'}
}
\value{
A data.frame sorted by the mean, sd, min, and max of the performance metric
}
\description{
Cross-validation for Classification and Regression Trees
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/crtree.html} for an example in Radiant
}
\examples{
\dontrun{
result <- crtree(dvd, "buy", c("coupon", "purch", "last"))
cv.crtree(result, cp = 0.0001, pcp = seq(0, 0.01, length.out = 11))
cv.crtree(result, cp = 0.0001, pcp = c(0, 0.001, 0.002), fun = profit, cost = 1, margin = 5)
result <- crtree(diamonds, "price", c("carat", "color", "clarity"), type = "regression", cp = 0.001)
cv.crtree(result, cp = 0.001, pcp = seq(0, 0.01, length.out = 11), fun = MAE)
}

}
\seealso{
\code{\link{crtree}} to generate an initial model that can be passed to cv.crtree

\code{\link{Rsq}} to calculate an R-squared measure for a regression

\code{\link{RMSE}} to calculate the Root Mean Squared Error for a regression

\code{\link{MAE}} to calculate the Mean Absolute Error for a regression

\code{\link{auc}} to calculate the area under the ROC curve for classification

\code{\link{profit}} to calculate profits for classification at a cost/margin threshold
}
