% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_activity_list.R
\name{get_activity_list}
\alias{get_activity_list}
\title{Get an activities list}
\usage{
get_activity_list(stoken, id = NULL, before = NULL, after = NULL, club = FALSE)
}
\arguments{
\item{stoken}{A \code{\link[httr]{config}} object created using the \code{\link{strava_oauth}} function}

\item{id}{character vector for id of the activity or club if \code{club = TRUE}, leave blank to retrieve all activities}

\item{before}{date object for filtering activities before the indicated date}

\item{after}{date object for filtering activities after the indicated date}

\item{club}{logical if you want the activities of a club}
}
\value{
A list of activities for further processing or plotting.
}
\description{
Get an activities list of the desired type (club, user)
}
\details{
Requires authentication stoken using the \code{\link{strava_oauth}} function and a user-created API on the strava website.  If retrieving activities using individual \code{id} values, the output list returned contains additional information from the API and the results have not been tested with the functions in this package.  It is better practice to retrieve all activities (as in the example below), use \code{\link{compile_activities}}, and then filter by individual activities.

If retrieving club activities, the user for the API must be a member of the club.
}
\examples{
\dontrun{
# create authentication token
# requires user created app name, id, and secret from Strava website
stoken <- httr::config(token = strava_oauth(app_name, app_client_id, 
	app_secret, cache = TRUE))

get_activity_list(stoken)
}
}
\concept{token}
