% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compile_club_activities.R
\name{compile_club_activities}
\alias{compile_club_activities}
\title{converts a list of club activities into a dataframe}
\usage{
compile_club_activities(actlist)
}
\arguments{
\item{actlist}{a club activities list returned by \code{\link{get_activity_list}}}
}
\value{
An \code{data.frame} of the compiled activities from \code{actlist}
}
\description{
converts a list of club activities into a dataframe
}
\details{
each activity has a value for every column present across all activities, with NAs populating empty values
}
\examples{
 
\dontrun{
stoken <- httr::config(token = strava_oauth(app_name, app_client_id, app_secret, cache = TRUE))

club_acts <- get_activity_list(stoken, id = 13502, club = TRUE)

acts_data <- compile_club_activities(club_acts)

}
}
\author{
Marcus Beck
}
\concept{token}
