mr.FDX = function(teststats,alpha,gamma,sequential=FALSE,ncombs=25){
  
  tsta = teststats
  sorttsta = t(apply(tsta,1,sort))
  tsta1 = tsta[1,]
  sorttsta1 = sorttsta[1,]
  
  m = ncol(tsta)
  w = nrow(tsta)
  sjs = numeric(w) #Vector containing the suprema s_g, for all w permutations/transformations
  
  
  
  for(j in 1:w){

    discont = sort( c(sorttsta[j,],sorttsta1   ) )   #discontinuities of function Rg_over_R
    
    Rg_over_R = numeric(2*m)
    
    for(i in 1:(2*m)){
      Rg_over_R[i] = (sum(sorttsta[j,]>discont[i]) )/(max(1,(sum(tsta1>discont[i]))))  #Rg_over_R at the i-th sorted test statistic for g. Note that Rg_over_R[infty]=0.
    }
    
    if(max(Rg_over_R)<=gamma) sjs[j] = discont[1]
    
    if(max(Rg_over_R)>gamma){
      criticalpoint = max(which(Rg_over_R>gamma))+1  
      sjs[j] = discont[criticalpoint]
    }
    
  }
  q = (sort(sjs))[ceiling((1-alpha)*w)] #q is the (1-alpha) quantile of the suprema s_g
  
  
  
  
  if(sequential==TRUE){
    if(!is.integer(ncombs)) stop("When sequential=TRUE, ncombs should be a positive integer (note: computation time is roughly linear in ncombs)")
    if(ncombs<1)  stop("ncombs should be a strictly positive integer")
    
    nrejections = sum(tsta1>q)
    
    
    Rset = (tsta1 > q)
    indR = which(Rset==TRUE)    #indices corresponding to rejected set
    indRc = which(Rset==FALSE)  
    
    finished = FALSE
    if(nrejections == 0 | nrejections == m) finished = TRUE
    
    while(finished==FALSE){
      
      q_previous = q #quantile from the previous iteration
      
      nrejections = sum(tsta1>q)
      boundV = floor(nrejections*gamma) #bound for V (nr of false positives) from previous iteration
      
      #Make a matrix combs2 where each column contains a combination of indices of hypotheses
      
      combs1 <- matrix(nrow = boundV,ncol=ncombs)
      if(boundV>0){
        for(i in 1:ncombs){
          combs1[,i]<- sample(indR,boundV,replace=FALSE)  #in every column, combs1 contains a combination of potential false positives
        }
      }
      
      combs2 = rbind(combs1, (as.matrix(indRc))[,rep(1, ncombs )] ) #add hypotheses that are not rejected
      
      
      #calculate threshold for each combination of hypotheses in combs2 and take max:
      
      qcs=numeric(ncombs)  #Will contain the q's based on different combinations of hypotheses
      
      for(c in 1:ncombs){
        
        reducedtsta = tsta[,combs2[,c]]  #the test statistics corresponding to the combination 
        sortreducedtsta = t(apply(reducedtsta,1,sort))
        
        
        for(j in 1:w){
          
          discont = sort( c(reducedtsta[j,],tsta1) )  #discontinuities
          ndisc = length(discont)
          Rg_over_R = numeric(ndisc) #Evaluate R(gX)/R(X) at the discontinuities
          
          for(i in 1:ndisc){
            Rg_over_R[i] = ( sum( reducedtsta[j,] > discont[i] ) )/ (max(1,(sum(tsta1 > discont[i]))))  
          }
          
          if(max(Rg_over_R)<=gamma){
            sjs[j] = discont[1]
          } else {
            criticalpoint = max(which(Rg_over_R>gamma))+1  
            sjs[j] = discont[criticalpoint]
          }
        }
        
        qcs[c] = (sort(sjs))[ceiling((1-alpha)*w)]
      } 
      q = min(q_previous,max(qcs))  #take the maximum, which represents the 'worst case'.
      
      if(q<q_previous){finished=FALSE} else{finished=TRUE} #stop when the quantile no longer improves
    } #end while loop
  }
  
  q  
  
}


