% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.plot.R
\name{with_trajectory}
\alias{with_trajectory}
\title{Adds trajectories to an ENA plot.}
\usage{
with_trajectory(
  x,
  ...,
  by = x$`_function.params`$conversation[1],
  add_jitter = TRUE,
  frame = 1100,
  transition = 1000,
  easing = "circle-in-out"
)
}
\arguments{
\item{x}{An ENA set object containing the plots.}

\item{...}{Additional arguments passed to the plotting functions.}

\item{by}{A character vector specifying the grouping variables for the trajectories. Default is the first conversation parameter in the ENA set.}

\item{add_jitter}{Logical; if `TRUE`, adds jitter to the trajectory points. Default is `TRUE`.}

\item{frame}{Numeric; the duration of each frame in the animation. Default is 1100.}

\item{transition}{Numeric; the duration of the transition between frames. Default is 1000.}

\item{easing}{A character string specifying the easing function for the animation. Default is "circle-in-out".}
}
\value{
Invisibly returns the modified ENA set object with updated plots.
}
\description{
This function generates trajectories for the plotted points in the ENA plot based on the specified grouping variables.
It supports options for jittering, animation, and scaling.
}
