% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qedata_classes.R
\name{as.qe.data}
\alias{as.qe.data}
\title{Convert an object to 'qe.data' class}
\usage{
as.qe.data(x)
}
\arguments{
\item{x}{An object. The object to be converted to 'qe.data' class.}
}
\value{
The modified object with the 'qe.data' class.
}
\description{
This function converts an object to the 'qe.data' class. If the object is not a data.frame or matrix, it is first converted to a data.table.
}
\examples{
library(data.table)

dt <- data.table(
  ID = 1:5,
  Name = c("Alice", "Bob", "Charlie", "David", "Eve"),
  Age = c(25, 30, 35, 40, 45),
  Score = c(85, 90, 95, 80, 75)
)
dt <- as.qe.data(dt);
class(dt) # Should show 'qe.data' along with other classes

}
