/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r.Planner;

import com.conveyal.r5.api.util.LegMode;
import com.conveyal.r5.api.util.StreetSegment;
import com.conveyal.r5.common.GeometryUtils;
import com.conveyal.r5.profile.McRaptorSuboptimalPathProfileRouter;
import com.conveyal.r5.profile.ProfileRequest;
import com.conveyal.r5.profile.StreetMode;
import com.conveyal.r5.profile.StreetPath;
import com.conveyal.r5.streets.EdgeStore;
import com.conveyal.r5.streets.StreetRouter;
import com.conveyal.r5.transit.RouteInfo;
import com.conveyal.r5.transit.TransitLayer;
import com.conveyal.r5.transit.TransportNetwork;
import com.conveyal.r5.transit.TripPattern;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.ipea.r5r.Planner.TripLeg;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Trip {
    private static final Logger LOG = LoggerFactory.getLogger(Trip.class);
    private boolean isDirect = false;
    private String fromId;
    private double fromLat;
    private double fromLon;
    private String toId;
    private double toLat;
    private double toLon;
    private int departureTime;
    private int totalDurationSeconds;
    private int totalDistance;
    private int totalFare;
    private String key;
    private final List<TripLeg> legs;

    public int directFirst() {
        return this.isDirect ? 0 : 1;
    }

    public String getFromId() {
        return this.fromId;
    }

    public double getFromLat() {
        return this.fromLat;
    }

    public double getFromLon() {
        return this.fromLon;
    }

    public String getToId() {
        return this.toId;
    }

    public double getToLat() {
        return this.toLat;
    }

    public double getToLon() {
        return this.toLon;
    }

    public int getDepartureTime() {
        return this.departureTime;
    }

    public int getTotalDurationSeconds() {
        return this.totalDurationSeconds;
    }

    public int getTotalDistance() {
        return this.totalDistance;
    }

    public int getTotalFare() {
        return this.totalFare;
    }

    public List<TripLeg> getLegs() {
        return this.legs;
    }

    public int getNumberOfLegs() {
        return this.legs.size();
    }

    public void setOD(String fromId, String toId, ProfileRequest request) {
        this.fromId = fromId;
        this.fromLat = request.fromLat;
        this.fromLon = request.fromLon;
        this.toId = toId;
        this.toLat = request.toLat;
        this.toLon = request.toLon;
    }

    public String getKey() {
        return this.key;
    }

    public void buildKey() {
        this.key = this.isDirect ? this.legs.iterator().next().getMode() : this.legs.stream().map(TripLeg::getRoute).filter(Predicate.not(String::isEmpty)).collect(Collectors.joining("|"));
    }

    public Trip() {
        this.legs = new ArrayList<TripLeg>();
    }

    public void addLeg(TripLeg leg) {
        this.legs.add(leg);
    }

    public static Trip newDirectTrip(int departureTime, String mode, StreetSegment streetSegment, EdgeStore edgeStore) {
        Trip trip = new Trip();
        trip.isDirect = true;
        trip.departureTime = departureTime;
        trip.totalDurationSeconds = streetSegment.duration;
        trip.totalDistance = streetSegment.distance;
        trip.totalFare = 0;
        trip.addLeg(TripLeg.newDirectLeg(mode, streetSegment, edgeStore));
        return trip;
    }

    public Trip(McRaptorSuboptimalPathProfileRouter.McRaptorState state, int departureTime, TransportNetwork network, ProfileRequest request) {
        this.departureTime = departureTime;
        this.totalDurationSeconds = state.time - departureTime;
        this.totalFare = state.fare != null ? state.fare.cumulativeFarePaid : 0;
        this.legs = new ArrayList<TripLeg>();
        try {
            this.loadTransitLegs(state, network, request);
            Collections.reverse(this.legs);
            this.buildKey();
        }
        catch (Exception e) {
            LOG.error("error loading legs");
            e.printStackTrace();
        }
    }

    public void augment(Map<LegMode, StreetRouter> accessRouter, Map<LegMode, StreetRouter> egressRouter, TransportNetwork network, ProfileRequest request, boolean OSMLinkIds) {
        HashMap<Integer, StreetSegment> accessPaths = new HashMap<Integer, StreetSegment>();
        HashMap<Integer, StreetSegment> egressPaths = new HashMap<Integer, StreetSegment>();
        MultiKeyMap transferPaths = new MultiKeyMap();
        if (!this.isDirect) {
            int tripDuration = 0;
            int tripDistance = 0;
            this.addAccessPath(accessRouter, accessPaths, network, request, OSMLinkIds);
            this.addEgressPath(egressRouter, egressPaths, network, request, OSMLinkIds);
            for (TripLeg leg : this.legs) {
                leg.augmentTransitLeg((MultiKeyMap<Integer, StreetSegment>)transferPaths, network, request, OSMLinkIds);
                tripDuration += leg.getLegDurationSeconds() + leg.getWaitTime();
                tripDistance += leg.getLegDistance();
            }
            this.totalDistance = tripDistance;
            this.totalDurationSeconds = tripDuration;
        } else {
            int tripDistance = 0;
            for (TripLeg leg : this.legs) {
                tripDistance += leg.augmentDirectLeg();
            }
            this.totalDistance = tripDistance;
        }
    }

    private void loadTransitLegs(McRaptorSuboptimalPathProfileRouter.McRaptorState state, TransportNetwork network, ProfileRequest request) {
        while (state != null) {
            if (state.stop != -1 && (state.pattern != -1 || state.back != null)) {
                if (state.pattern == -1) {
                    Coordinate destStopCoord;
                    Coordinate originStopCoord;
                    int originTime = state.back.time;
                    int destTime = state.time;
                    int fare = state.fare != null ? state.fare.cumulativeFarePaid : 0;
                    int destStopIndex = state.stop;
                    int originStopIndex = state.back.stop;
                    LineString geom = GeometryUtils.geometryFactory.createLineString(new Coordinate[0]);
                    if (originStopIndex != destStopIndex & (originStopCoord = network.transitLayer.getCoordinateForStopFixed(originStopIndex)) != null & (destStopCoord = network.transitLayer.getCoordinateForStopFixed(destStopIndex)) != null) {
                        geom = GeometryUtils.geometryFactory.createLineString(new Coordinate[]{new Coordinate(originStopCoord.getX() / 1.0E7, originStopCoord.getY() / 1.0E7), new Coordinate(destStopCoord.getX() / 1.0E7, destStopCoord.getY() / 1.0E7)});
                    }
                    leg = TripLeg.newTransferLeg(StreetMode.WALK.toString(), destTime - originTime, fare, geom, null, null);
                    leg.setODStops(originStopIndex, destStopIndex);
                    this.legs.add(leg);
                } else {
                    TripPattern pattern = (TripPattern)network.transitLayer.tripPatterns.get(state.pattern);
                    int boardStopIndex = pattern.stops[state.boardStopPosition];
                    int alightStopIndex = pattern.stops[state.alightStopPosition];
                    RouteInfo route = (RouteInfo)network.transitLayer.routes.get(pattern.routeIndex);
                    String mode = TransitLayer.getTransitModes((int)route.route_type).toString();
                    int duration = state.time - state.boardTime;
                    int wait = state.boardTime - state.back.time;
                    int fare = state.fare != null ? state.fare.cumulativeFarePaid : 0;
                    leg = TripLeg.newTransitLeg(mode, duration, fare, wait, boardStopIndex, alightStopIndex, route.route_id);
                    leg.setPatternData(pattern, state.boardStopPosition, state.alightStopPosition);
                    this.legs.add(leg);
                }
            }
            state = state.back;
        }
    }

    private void addAccessPath(Map<LegMode, StreetRouter> accessRouter, Map<Integer, StreetSegment> accessPaths, TransportNetwork network, ProfileRequest request, boolean OSMLinkIds) {
        TripLeg leg = this.legs.get(0);
        int startStopIndex = leg.getBoardStop();
        int startVertexStopIndex = network.transitLayer.streetVertexForStop.get(startStopIndex);
        LegMode accessMode = (LegMode)request.accessModes.iterator().next();
        if (accessMode != null) {
            StreetSegment streetSegment = accessPaths.get(startVertexStopIndex);
            EdgeStore edgeStore = null;
            if (OSMLinkIds) {
                edgeStore = network.streetLayer.edgeStore;
            }
            if (streetSegment == null) {
                StreetRouter streetRouter = accessRouter.get(accessMode);
                streetRouter.profileRequest.reverseSearch = false;
                StreetRouter.State streetState = streetRouter.getStateAtVertex(startVertexStopIndex);
                if (streetState != null) {
                    StreetPath streetPath = new StreetPath(streetState, network, false);
                    streetSegment = new StreetSegment(streetPath, accessMode, network.streetLayer);
                    TripLeg accessLeg = TripLeg.newTransferLeg(accessMode.toString(), streetSegment.duration, 0, streetSegment.geometry, streetSegment, edgeStore);
                    this.legs.add(0, accessLeg);
                    accessPaths.put(startVertexStopIndex, streetSegment);
                } else {
                    LOG.warn("Access: Last state not found for mode:{} stop:{}({})", new Object[]{accessMode, startVertexStopIndex, startStopIndex});
                }
            } else {
                TripLeg accessLeg = TripLeg.newTransferLeg(accessMode.toString(), streetSegment.duration, 0, streetSegment.geometry, streetSegment, edgeStore);
                this.legs.add(0, accessLeg);
                accessPaths.put(startVertexStopIndex, streetSegment);
            }
        } else {
            LOG.warn("Mode is not in stopModeAccessMap for start stop:{}({})", (Object)startVertexStopIndex, (Object)startStopIndex);
        }
    }

    private void addEgressPath(Map<LegMode, StreetRouter> egressRouter, Map<Integer, StreetSegment> egressPaths, TransportNetwork network, ProfileRequest request, boolean OSMLinkIds) {
        TripLeg leg = this.legs.get(this.legs.size() - 1);
        int cumulativeFare = leg.getCumulativeFare();
        int endStopIndex = leg.getAlightStop();
        int endVertexStopIndex = network.transitLayer.streetVertexForStop.get(endStopIndex);
        LegMode egressMode = (LegMode)request.egressModes.iterator().next();
        if (egressMode != null) {
            StreetSegment streetSegment = egressPaths.get(endVertexStopIndex);
            EdgeStore edgeStore = null;
            if (OSMLinkIds) {
                edgeStore = network.streetLayer.edgeStore;
            }
            if (streetSegment == null) {
                StreetRouter streetRouter = egressRouter.get(egressMode);
                streetRouter.profileRequest.reverseSearch = true;
                StreetRouter.State streetState = streetRouter.getStateAtVertex(endVertexStopIndex);
                if (streetState != null) {
                    StreetPath streetPath = new StreetPath(streetState, network, true);
                    streetSegment = new StreetSegment(streetPath, egressMode, network.streetLayer);
                    TripLeg egressLeg = TripLeg.newTransferLeg(egressMode.toString(), streetSegment.duration, cumulativeFare, streetSegment.geometry, streetSegment, edgeStore);
                    this.legs.add(egressLeg);
                } else {
                    LOG.warn("EGRESS: Last state not found for mode:{} stop:{}({})", new Object[]{egressMode, endVertexStopIndex, endStopIndex});
                }
            } else {
                TripLeg egressLeg = TripLeg.newTransferLeg(egressMode.toString(), streetSegment.duration, cumulativeFare, streetSegment.geometry, streetSegment, edgeStore);
                this.legs.add(egressLeg);
                egressPaths.put(endVertexStopIndex, streetSegment);
            }
        } else {
            LOG.warn("Mode is not in stopModeEgressMap for END stop:{}({})", (Object)endVertexStopIndex, (Object)endStopIndex);
        }
    }
}

