% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{shift}
\alias{shift}
\title{Shift a Vector (i.e., lag/lead)}
\usage{
shift(x, n, undefined = NA)
}
\arguments{
\item{x}{atomic vector or list vector.}

\item{n}{integer vector with length 1. Specifies the direction and magnitude
of the shift. See details.}

\item{undefined}{atomic vector with length 1 (probably makes sense to be the
same typeof as \code{x}). Specifies what to insert for undefined values
after the shifting takes place. See details.}
}
\value{
an atomic vector of the same length as \code{x} that is shifted. If
  \code{x} and \code{undefined} are different typeofs, then the return will
  be coerced to the more complex typeof (i.e., complex to simple: character,
  double, integer, logical).
}
\description{
\code{shift} shifts elements of a vector right (\code{n} < 0) for lags or
left (\code{n} > 0) for leads replacing the undefined data with a
user-defined value (e.g., NA). The number of elements shifted is equal to
\code{abs(n)}. It is assumed that \code{x} is already sorted by time such
that the first element is earliest in time and the last element is the latest
in time.
}
\details{
If \code{n} is negative, then \code{shift} inserts \code{undefined} into the
first \code{abs(n)} elements of \code{x}, shifting all other values of
\code{x} to the right \code{abs(n)} positions, and then dropping the last
\code{abs(n)} elements of \code{x} to preserve the original length of
\code{x}. If \code{n} is positive, then \code{shift} drops the first
\code{abs(n)} elements of \code{x}, shifting all other values of \code{x}
left \code{abs(n)} positions, and then inserts \code{undefined} into the last
\code{abs(n)} elements of \code{x} to preserve the original length of
\code{x}. If \code{n} is zero, then \code{shift} simply returns \code{x}.

It is recommended to use \code{L} when specifying \code{n} to prevent
problems with floating point numbers. \code{shift} tries to circumvent this
issue by a call to \code{round} within \code{shift} if \code{n} is not an
integer; however that is not a complete fail safe. The problem is that
\code{as.integer(n)} implicit in \code{shift} truncates rather than rounds.
}
\examples{
shift(x = attitude[[1]], n = -1L) # use L to prevent problems with floating point numbers
shift(x = attitude[[1]], n = -2L) # can specify any integer up to the length of `x`
shift(x = attitude[[1]], n = +1L) # can specify negative or positive integers
shift(x = attitude[[1]], n = +2L, undefined = -999) # user-specified indefined value
shift(x = setNames(object = letters, nm = LETTERS), n = 3L) # names are kept
}
\seealso{
\code{\link{shifts}}
   \code{\link{shift_by}}
   \code{\link{shifts_by}}
}
