% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psymet_functions.R
\name{nhst}
\alias{nhst}
\title{Null Hypothesis Significance Testing}
\usage{
nhst(est, se, df = Inf, ci.level = 0.95, p.value = "two.sided")
}
\arguments{
\item{est}{numeric vector of parameter estimates.}

\item{se}{numeric vector of standard errors. Must be the same length as
\code{est}.}

\item{df}{numeric vector of degrees of freedom. Must be length of 1 or have
same length as \code{est} and \code{se}. If degrees of freedom are not
applicable or available, then \code{df} can be set to \code{Inf} (the
default) and z-values rather than t-values will be computed. Note,
\code{df} can be non-integers with decimals.}

\item{ci.level}{double vector of length 1 specifying the confidence level.
Must be between 0 and 1 - or can be NULL in which case no confidence
intervals are computed and the return object does not have the columns
"lwr" or "upr".}

\item{p.value}{character vector of length 1 specifying the type of p-values
to compute. The options are 1) "two.sided" which computed non-directional,
two-tailed p-values, 2) "less", which computes negative-directional,
one-tailed p-values, or 3) "greater", which computes positive-directional,
one-tailed p-values.}
}
\value{
data.frame with nrow equal to the lengths of \code{est} and
\code{se}. The rownames are taken from \code{est}, unless \code{est} does not
have any names and then the rownames are taken from the names of \code{se}.
If neither have names, then the rownames are automatic (i.e.,
\code{1:nrow()}). The columns are the following:

\describe{
   \item{est}{parameter estimates}
   \item{se}{standard errors}
   \item{t}{t-values (z-values if df = Inf)}
   \item{df}{degrees of freedom}
   \item{p}{p-values}
   \item{lwr}{lower bound of the confidence intervals (excluded if \code{ci.level =  NULL})}
   \item{upr}{upper bound of the confidence intervals (excluded if \code{ci.level =  NULL})}
}
}
\description{
\code{nhst} computes the statistical information for null hypothesis
significance testing (NHST), t-values, p-values, etc., from parameter
estimates, standard errors, and degrees of freedom. If degrees of freedom are
not applicable or available, then \code{df} can be set to \code{Inf} (the
default) and z-values rather than t-values will be computed.
}
\examples{

est <- colMeans(attitude)
se <- apply(X = str2str::d2m(attitude), MARGIN = 2, FUN = function(vec)
   sqrt(var(vec) / length(vec)))
df <- nrow(attitude) - 1
nhst(est = est, se = se, df = df)
nhst(est = est, se = se) # default is df = Inf resulting in z-values
nhst(est = est, se = se, df = df, ci.level = NULL) # no "lwr" or "upr" columns
nhst(est = est, se = se, df = df, ci.level = 0.99)

}
\seealso{
\code{\link{confint2.default}}
}
