% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psymet_functions.R
\name{make.latent}
\alias{make.latent}
\title{Make Model Syntax for a Latent Factor in Lavaan}
\usage{
make.latent(
  x,
  nm.latent = "latent",
  error.var = FALSE,
  nm.par = FALSE,
  suffix.load = "_l",
  suffix.error = "_e"
)
}
\arguments{
\item{x}{character vector specifying the colnames in your data that
correspond to the variables indicating the latent factor (e.g.,
questionnaire items).}

\item{nm.latent}{character vector of length 1 specifying what the latent
factor should be labeled as in the return object.}

\item{error.var}{logical vector of length 1 specifying whether the model
syntax for the error variances should be included in the return object.}

\item{nm.par}{logical vector of length 1 specifying whether the model syntax
should include names for the factor loading (and error variance)
parameters.}

\item{suffix.load}{character vector of length 1 specifying what string should
be appended to the end of the elements of \code{x} when creating names for
the factor loading parameters. Only used if \code{nm.par} is TRUE.}

\item{suffix.error}{character vector of length 1 specifying what string
should be appended to the end of the elements of \code{x} when creating
names for the error variance parameters. Only used if \code{nm.par} is
TRUE.}
}
\value{
character vector of length 1 providing the model syntax. The regular
  expression "\\n" is used to delineate new lines within the model
  syntax.
}
\description{
\code{make.latent} makes the model syntax for a latent factor in
\code{lavaan}. The return object can be used as apart of the model syntax for
calls to \code{\link[lavaan]{lavaan}}, \code{\link[lavaan]{sem}},
\code{\link[lavaan]{cfa}}, etc.
}
\examples{

make.latent(x = names(psych::bfi)[1:5], error.var = FALSE, nm.par = FALSE)
make.latent(x = names(psych::bfi)[1:5], error.var = FALSE, nm.par = TRUE)
make.latent(x = names(psych::bfi)[1:5], error.var = TRUE, nm.par = FALSE)
make.latent(x = names(psych::bfi)[1:5], error.var = TRUE, nm.par = TRUE)

}
