% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfm-print.R
\name{format_sparsity}
\alias{format_sparsity}
\title{format a sparsity value for printing}
\usage{
format_sparsity(x)
}
\arguments{
\item{x}{input sparsity value, ranging from 0 to 1.0}
}
\description{
Inputs a dfm sparsity value from \code{\link[=sparsity]{sparsity()}} and formats it for
printing in \code{print.dfm()}.
}
\examples{
ss <- c(1, .99999, .9999, .999, .99, .9,
       .1, .01, .001, .0001, .000001, .0000001, .00000001, .000000000001, 0)
for (s in ss) 
    cat(format(s, width = 10),  ":", quanteda:::format_sparsity(s), "\n")
}
\keyword{internal}
