#' Q-Q and P-P plot extensions for 'ggplot2'
#'
#' This package extends some \code{ggplot2} functionalities by permitting the
#' drawing of both quantile-quantile (Q-Q) and probability-probability (P-P)
#' points, lines, and confidence bands. The functions of this package also allow
#' the detrend adjustment, proposed by Thode (2002), which helps reduce visual
#' bias when assessing those plots.
#'
#' The functions of this package, presented as \code{ggplot2} Stats, are divided
#' into two groups: Q-Q and P-P related.
#'
#' Each of the groups is composed of three Stats: \code{point}, \code{line}, and
#' \code{band}. Those Stats, while independent, complement each other when
#' plotted together.
#'
#' @name qqplotr
"_PACKAGE"
