% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/excel_helpers.R
\name{modify_number_formats}
\alias{modify_number_formats}
\title{Modify Number Formats Used by \code{\link[=any_table]{any_table()}}}
\usage{
modify_number_formats(formats_to_modify, ...)
}
\arguments{
\item{formats_to_modify}{Pre created number formats where only certain elements
should be modified while the rest is kept as is.}

\item{...}{Pass in names and corresponding new values for existing number formats.}
}
\value{
Returns a modified list of number format options.
}
\description{
Modify previously created number formats with \code{\link[=number_format_style]{number_format_style()}}.
}
\details{
\code{\link[=modify_number_formats]{modify_number_formats()}} is based on 'SAS' number formats and the Output Delivery
System (ODS), which provides efficient and readable ways to set up different table
styles.

With the number format style you have full control over formatting numbers according
to the different statistics. There is no need to think about calculating the right
place to input the number formats and how to do this in a loop for multiple cells.
Just input the different number formats and decimals for the different statistics
and everything else is handled by the functions capable of using number styles.

The concept basically is: design over complex calculations.
}
\examples{
# For default values
format_list <- number_format_style(pct_excel    = "0.00000000",
                                   pct_decimals = 8)

# Set specific options, the rest will be kept as is
format_list <- format_list |> modify_number_formats(sum_excel = "#,###,##0.000")

# IMPORTANT: Don't forget to add individual formats to an excel style, otherwise
# they won't come into affect.
excel_style <- excel_output_style(number_formats = format_list)

}
\seealso{
Creating a custom table style: \code{\link[=excel_output_style]{excel_output_style()}}, \code{\link[=modify_output_style]{modify_output_style()}},
\code{\link[=number_format_style]{number_format_style()}}.

Functions that can handle styles: \code{\link[=frequencies]{frequencies()}}, \code{\link[=crosstabs]{crosstabs()}}, \code{\link[=any_table]{any_table()}},
\code{\link[=export_with_style]{export_with_style()}}.
}
