% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversion.R
\name{args_to_char}
\alias{args_to_char}
\title{Convert Ellipsis to Character Vector}
\usage{
args_to_char(...)
}
\arguments{
\item{...}{Used for variable names listed in ... without the need to put them in c() or list()}
}
\value{
Returns a character vector
}
\description{
When you define a function and want the user to be able to pass variable
names without the need to have them stored in a vector c() or list() beforehand and without
putting the names into quotation marks, you can convert this variable list passed as ...
into a character vector.

Note: If the user passes a list of characters it is returned as given.
}
\examples{
# Example function
print_vnames <- function(...){
    var_names <- args_to_char(...)
    print(var_names)
}

print_vnames(age, sex, income, weight)
print_vnames("age", "sex", "income", "weight")

# You can also pass in a character vector, if you have stored variable names elsewhere
var_names <- c("age", "sex", "income", "weight")
print_vnames(var_names)

}
